<?php

namespace Drupal\sharepoint_integration\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;

final class ModalInfoController extends ControllerBase {
  public function multiNodeInfo() {
    return [
      '#type' => 'container',
      'title' => [
        '#type' => 'html_tag',
        '#tag' => 'h3',
        '#value' => $this->t('Create Multiple Nodes (Premium)'),
      ],
      'body' => [
        '#markup' => $this->t('The Free version supports one Drupal node. To create nodes for multiple drives, please upgrade to the Premium version.'),
      ],
      'actions' => [
        '#type' => 'container',
        'upgrade' => [
          '#type' => 'link',
          '#title' => $this->t('View Premium Features'),
          '#url' => Url::fromRoute('sharepoint_integration.upgrade_plan'),
          '#attributes' => ['class' => ['button', 'button--primary']],
        ],
        'trial' => [
          '#type' => 'link',
          '#title' => $this->t('Request Trial'),
          '#url' => Url::fromRoute('sharepoint_integration.request_trial'),
          '#attributes' => ['class' => ['button']],
        ],
      ],
      '#attached' => [
        'library' => ['core/drupal.dialog.ajax'],
      ],
    ];
  }

  /**
   * Modal for Preview feature (Premium CTA).
   */
  public function previewInfo() {
    return [
      '#type' => 'container',
      'title' => [
        '#type' => 'html_tag',
        '#tag' => 'h3',
        '#value' => $this->t('Preview Files (Premium)'),
      ],
      'body' => [
        '#markup' => $this->t('The Free version disables file preview for end users. Upgrade to the Premium version to enable in-place file previews (Office, PDF, images) and embedded viewers securely with SharePoint permissions.'),
      ],
      'actions' => [
        '#type' => 'container',
        'upgrade' => [
          '#type' => 'link',
          '#title' => $this->t('View Premium Features'),
          '#url' => Url::fromRoute('sharepoint_integration.upgrade_plan'),
          '#attributes' => ['class' => ['button', 'button--primary']],
        ],
        'trial' => [
          '#type' => 'link',
          '#title' => $this->t('Request Trial'),
          '#url' => Url::fromRoute('sharepoint_integration.request_trial'),
          '#attributes' => ['class' => ['button']],
        ],
      ],
      '#attached' => [
        'library' => ['core/drupal.dialog.ajax'],
      ],
    ];
  }
}


