<?php

namespace Drupal\shorthand;

use Drupal\Core\Entity\Sql\SqlContentEntityStorage;
use Drupal\Core\Language\LanguageInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\shorthand\Entity\ShorthandStoryInterface;

/**
 * Defines the storage handler class for Shorthand story entities.
 *
 * This extends the base storage class, adding required special handling for
 * Shorthand story entities.
 *
 * @ingroup shorthand
 *
 * @deprecated in shorthand:4.0.0 and is removed from shorthand:5.0.0. Use
 *   shorthand field.
 *
 * @see https://www.drupal.org/project/shorthand/issues/3274487
 */
class ShorthandStoryStorage extends SqlContentEntityStorage implements ShorthandStoryStorageInterface {

  /**
   * {@inheritdoc}
   *
   * @deprecated in shorthand:4.0.0 and is removed from shorthand:5.0.0. Use
   *   shorthand field.
   *
   * @see https://www.drupal.org/project/shorthand/issues/3274487
   */
  public function revisionIds(ShorthandStoryInterface $entity) {
    return $this->database->query(
      'SELECT vid FROM {shorthand_story_revision} WHERE id=:id ORDER BY vid',
      [':id' => $entity->id()]
    )->fetchCol();
  }

  /**
   * {@inheritdoc}
   *
   * @deprecated in shorthand:4.0.0 and is removed from shorthand:5.0.0. Use
   *   shorthand field.
   *
   * @see https://www.drupal.org/project/shorthand/issues/3274487
   */
  public function userRevisionIds(AccountInterface $account) {
    return $this->database->query(
      'SELECT vid FROM {shorthand_story_field_revision} WHERE uid = :uid ORDER BY vid',
      [':uid' => $account->id()]
    )->fetchCol();
  }

  /**
   * {@inheritdoc}
   *
   * @deprecated in shorthand:4.0.0 and is removed from shorthand:5.0.0. Use
   *   shorthand field.
   *
   * @see https://www.drupal.org/project/shorthand/issues/3274487
   */
  public function countDefaultLanguageRevisions(ShorthandStoryInterface $entity) {
    return $this->database->query('SELECT COUNT(*) FROM {shorthand_story_field_revision} WHERE id = :id AND default_langcode = 1', [':id' => $entity->id()])
      ->fetchField();
  }

  /**
   * {@inheritdoc}
   *
   * @deprecated in shorthand:4.0.0 and is removed from shorthand:5.0.0. Use
   *   shorthand field.
   *
   * @see https://www.drupal.org/project/shorthand/issues/3274487
   */
  public function clearRevisionsLanguage(LanguageInterface $language) {
    return $this->database->update('shorthand_story_revision')
      ->fields(['langcode' => LanguageInterface::LANGCODE_NOT_SPECIFIED])
      ->condition('langcode', $language->getId())
      ->execute();
  }

}
