/**
 * @file
 * A Backbone Model for widget items in SHS.
 */

(function (Backbone, Drupal) {

  'use strict';


  /**
   * Backbone model for widget items in SHS.
   *
   * @constructor
   *
   * @augments Backbone.Model
   */
  Drupal.shs.WidgetItemModel = Backbone.Model.extend(/** @lends Drupal.shs.WidgetItemModel# */{
    /**
     * @type {object}
     *
     * @prop {integer} tid
     * @prop {string} langcode
     * @prop {string} name
     * @prop {string} description
     */
    defaults: /** @lends Drupal.shs.WidgetItemModel# */{

      /**
       * Represents the term Id.
       *
       * @type {integer}
       */
      tid: null,

      /**
       * Language code of the term.
       *
       * @type {string}
       */
      langcode: null,

      /**
       * Name (label) of the term.
       *
       * @type {string}
       */
      name: '',

      /**
       * Description of the term.
       *
       * @type {string}
       */
      description: '',

      /**
       * Indicator whether the item has children.
       *
       * @type {boolean}
       */
      hasChildren: false,

      /**
       * Attribute to use as Id.
       *
       * @type {string}
       */
      idAttribute: 'tid'
    },

    /**
     * {@inheritdoc}
     */
    initialize: function () {
      // Set internal id to termId.
      this.set('id', this.get('tid'));
    },

    /**
     * {@inheritdoc}
     */
    parse: function (response, options) {
      return {
        tid: response.tid,
        name: response.name,
        description: response.description__value,
        langcode: response.langcode,
        hasChildren: response.hasChildren
      };
    }
  });

}(Backbone, Drupal));
