((Drupal, drupalSettings, once) => {
  Drupal.behaviors.sibsPaymentStatus = {
    attach(context) {
      const cfg = drupalSettings && drupalSettings.sibsApi ? drupalSettings.sibsApi : NULL;
      if (!cfg || !cfg.orderId) { return;
      }

      const nodes = once('sibsPaymentStatus', '#sibs-payment-status', context);
      if (!nodes || nodes.length === 0) { return;
      }

      nodes.forEach((box) => {
        // evita múltiplos inits no mesmo element (por segurança)
        if (box.dataset.sibsInitialized) { return;
        }
        box.dataset.sibsInitialized = '1';

        const spinner = box.querySelector('.sibs-spinner');
        const timerEl = box.querySelector('#sibs-timer-count');

        if (!timerEl) {
          const timerWrapper = document.createElement('p');
          timerWrapper.className = 'sibs-timer';
          const strong = document.createElement('strong');
          strong.id = 'sibs-timer-count';
          strong.textContent = '06:00';
          timerWrapper.appendChild(strong);
          box.appendChild(timerWrapper);
        }

        const timer = box.querySelector('#sibs-timer-count');

        let remaining = parseInt(cfg.timerStart, 10) || 360; // segundos
        const pollIntervalMs = (parseInt(cfg.pollInterval, 10) || 5) * 1000;
        const endpoint = ` / sibs - api - commerce / payment - status / ${cfg.orderId}`;

        function formatTime(s) {
          const m = Math.floor(s / 60);
          const sec = s % 60;
          return `${m.toString().padStart(2, '0')}:${sec.toString().padStart(2, '0')}`;
        }

        if (timer) { timer.textContent = formatTime(remaining);
        }

        let poll = NULL;
        const stopAll = () => {
          if (poll) {
            clearInterval(poll);
            poll = NULL;
          }
          if (countdownInterval) {
            clearInterval(countdownInterval);
          }
        };

        const countdownInterval = setInterval(() => {
          if (remaining > 0) {
            remaining--;
            if (timer) { timer.textContent = formatTime(remaining);
            }
          } else {
            stopAll();
            if (spinner) { spinner.remove();
            }
            box.innerHTML = `
              < p class = "sibs-fail" >
                < svg xmlns = "http://www.w3.org/2000/svg" width = "24" height = "24" fill = "#d93025" viewBox = "0 0 24 24" >
                  < path d = "M18.364 5.636l-1.414-1.414-5.95 5.95-5.95-5.95-1.414 1.414 5.95 5.95-5.95 5.95 1.414 1.414 5.95-5.95 5.95 5.95 1.414-1.414-5.95-5.95z" / >
                < / svg >
                ${Drupal.t('The MB WAY payment request expired. Please try again.')}
              < / p >
            `;
          }
        }, 1000);

        function showResult(type, message) {
          stopAll();
          if (spinner) { spinner.remove();
          }
          if (type === 'success') {
            box.innerHTML = `
              < p class = "sibs-success" >
                < svg xmlns = "http://www.w3.org/2000/svg" width = "24" height = "24" fill = "#1a7f37" viewBox = "0 0 24 24" >
                  < path d = "M20.285 6.709l-11.57 11.571-5.571-5.571 1.414-1.414 4.157 4.157 10.156-10.157z" / >
                < / svg >
                ${Drupal.t(message)}
              < / p >
            `;
          } else {
            box.innerHTML = `
              < p class = "sibs-fail" >
                < svg xmlns = "http://www.w3.org/2000/svg" width = "24" height = "24" fill = "#d93025" viewBox = "0 0 24 24" >
                  < path d = "M18.364 5.636l-1.414-1.414-5.95 5.95-5.95-5.95-1.414 1.414 5.95 5.95-5.95 5.95 1.414 1.414 5.95-5.95 5.95 5.95 1.414-1.414-5.95-5.95z" / >
                < / svg >
                ${Drupal.t(message)}
              < / p >
            `;
          }
        }

        const doPoll = async() => {
          try {
            const response = await fetch(endpoint, { credentials: 'same-origin' });
            if (!response.ok) { return;
            }
            const data = await response.json();
            const status = (data.status || '').toString();

            if (status === 'Success') {
              showResult('success', 'Payment confirmed successfully!');
            } else if (status === 'Declined' || status === 'Failed') {
              showResult('fail', 'Payment failed or canceled.');
            } else if (status === 'Timeout') {
              showResult('fail', 'Payment timed out. Please try again.');
            }
          } catch (err) {
          }
        };

        doPoll();
        poll = setInterval(doPoll, pollIntervalMs);
      });
    },
  };
})(Drupal, drupalSettings, once);
