<?php

namespace Drupal\sibs_api_commerce\Controller;


use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\commerce_payment\Entity\Payment;

class PaymentStatusController {
  public function getStatus($order_id) {
    $payments = \Drupal::entityTypeManager()
      ->getStorage('commerce_payment')
      ->loadByProperties(['order_id' => $order_id]);

    $payment = reset($payments);
    if (!$payment) {
      return new JsonResponse(['status' => 'NotFound'], 404);
    }

    $service = \Drupal::service('sibs_api.spg');
    $status = $service->getPaymentStatus($payment->remote_id->value);
    $payment_status = $status['paymentStatus'] ?? 'Unknown';

    $order = $payment->getOrder();
   
    if ($payment_status === 'Success') {
      if ($payment->getState()->value == 'new') {
          $payment->setState('completed');
          $payment->save();
          $payment_gateway = $order->get('payment_gateway')->entity;
          if($payment_gateway->getPlugin()->getConfiguration()['transition_state'] == '1'){
            $payment_accepted = $payment_gateway->getPlugin()->getConfiguration()['transition_machinename_accepted'];
            if(!empty($payment_accepted)){
              $order_state = $order->getState();
              $order_state->applyTransitionById($payment_accepted);
              $order->save();
            }
          }
        }
    }
    elseif ($payment_status === 'Declined') {
      if ($payment->getState()->value == 'new') {
        $payment->setState('declined');
        $payment->save();
        $payment_gateway = $order->get('payment_gateway')->entity;
        if($payment_gateway->getPlugin()->getConfiguration()['transition_state'] == '1'){
          $payment_failed = $payment_gateway->getPlugin()->getConfiguration()['transition_machinename_failed'];
          if(!empty($payment_failed)){
            $order_state = $order->getState();
            $order_state->applyTransitionById($payment_failed);
            $order->save();
          }
        }
      }
    }

    return new JsonResponse([
      'status' => $status['paymentStatus'] ?? 'Unknown',
      'raw' => $status,
    ]);
  }
}
