<?php

namespace Drupal\sibs_api_commerce\Plugin\Commerce\PaymentGateway;

use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\OffsitePaymentGatewayBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\HttpFoundation\Request;
use Drupal\commerce_payment\Exception\PaymentGatewayException;

/**
 * Provides the Off-site Redirect payment gateway.
 *
 * @CommercePaymentGateway(
 *   id = "sibs_api_spg_commerce",
 *   label = "SIBS API SPG OFFSITE",
 *   display_label = "SIBS SPG",
 *   forms = {
 *     "offsite-payment" = "Drupal\sibs_api_commerce\Plugin\Commerce\PluginForm\SibsSPGCommerceForm",
 *   },
 * )
 */
class SibsSPGCommerce extends OffsitePaymentGatewayBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'redirect_method' => 'post',
      'spg_methods' => '',
    ] + parent::defaultConfiguration();
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);
    $form['spg_methods'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Avaliable payment methods'),
      '#options' => [
        "REFERENCE" => $this->t("REFERENCE"),
        "CARD" => $this->t("CARD"),
        "MBWAY" => $this->t("MBWAY"),
      ],
      '#default_value' => $this->configuration['spg_methods'],
      '#required' => 1,
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);
    $values = $form_state->getValue($form['#parents']);
    $this->configuration['spg_methods'] = $values['spg_methods'];
  }

  /**
   * {@inheritdoc}
   */
  public function onReturn(OrderInterface $order, Request $request) {
    $payment_storage = \Drupal::entityTypeManager()->getStorage('commerce_payment');
    $payments = $payment_storage->loadMultipleByOrder($order);
    $payment = end($payments);
    $service = \Drupal::service('sibs_api.spg');
    $status = $service->getpaymentStatus($payment->remote_id->value);

    if ($status["paymentStatus"] == 'Declined' || $status["paymentStatus"] == 'Timeout') {
      throw new PaymentGatewayException("Failed");
    }
  }

}
