<?php

namespace Drupal\sibs_api_commerce\Plugin\Commerce\PluginForm;

use Drupal\commerce_payment\PluginForm\PaymentOffsiteForm as BasePaymentOffsiteForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Build and redirect SIBS SPG form.
 */
class SibsSPGCommerceForm extends BasePaymentOffsiteForm {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);

    /** @var \Drupal\commerce_payment\Entity\PaymentInterface $payment */
    $payment = $this->entity;
    $payment_gateway_plugin = $payment->getPaymentGateway()->getPlugin();
    $spg_methods = $payment_gateway_plugin->getConfiguration();

    $service = \Drupal::service('sibs_api.spg');
    $methods_array = [];
    foreach ($spg_methods['spg_methods'] as $value) {
      if (!empty($value)) {
        $methods_array[] = $value;
      }
    }

    $methods = $methods_array;

    $amount = $payment->getAmount()->getNumber();
    $desc = $this->t('Payment for property @nid', ['@nid' => $payment->getOrderId()]);

    $checkout = $service->prepareCheckout($amount, $methods, $desc);
    $data['continueurl'] = $form['#return_url'];
    $data['cancelurl'] = $form['#cancel_url'];

    if (isset($checkout['transactionID']) && !empty($checkout['transactionID'])) {
      $payment->set('remote_id', $checkout['transactionID']);
      $payment->save();

      $tempstore = \Drupal::service('tempstore.private')->get('sibs_api');
      $checkout['redirectUrl'] = $form['#return_url'];
      $tempstore->set($checkout['transactionID'], $checkout);

      return $this->buildRedirectForm(
        $form,
        $form_state,
        '/sibs-api/form/' . $checkout['transactionID'],
        $data,
        self::REDIRECT_POST
      );
    }
  }

}
