# Sidenotes (Drupal 10/11)

A lightweight custom module that lets editors create Tufte-style sidenotes directly in body text using simple markup. Notes can be numbered or unnumbered, placed in the left or right margin, and render responsively (inline or as endnotes on mobile).

## Features

- Text filter that converts `[sn]...[/sn]` or `((...))` into sidenotes
- Optional numbering like footnotes (or use a generic mark)
- Left or right margin placement (site default)
- Mobile behavior: inline after the reference, or move to an endnotes list
  - Inline placement configurable: after paragraph (default) or after reference
- Responsive CSS with themable class names and CSS variables
- Minimal JS to handle endnotes on mobile and reflow on resize
- Endnotes section title configurable
- Label styles: Numbers, Symbols (*, †, ††, §, ¶, ‖, Δ, ◊, ☞), or None
  - Custom: Define your own labels (e.g., <strong>[wik]</strong>) and use them as the label style
  - Per-note overrides:
    - Unnumbered marker (configurable, default `!@`) with configurable display symbol (default `✶`)
    - Specific symbol via code markers, e.g., `!d!` (dagger), `!dd!` (double dagger), `!ast!` (*), `!sec!` (§), `!para!` (¶), `!parallel!` (‖), `!delta!` (Δ), `!lozenge!` (◊), `!hand!` (☞)
    - Custom label override via a configured marker (e.g., `!wik!`) mapped to <strong>[wik]</strong>
      - Outside of Symbols or Custom modes, these overrides do not increment numbering (they act like unnumbered for numbering purposes).
      - Outside of Symbols mode, these overrides do not increment numbering (they act like unnumbered for numbering purposes).

## Install

1. Place this module at `web/modules/custom/sidenotes`.
2. Enable the module: Extend → Sidenotes (or `drush en sidenotes`).
3. Configure defaults at Configuration → Content authoring → Sidenotes (`/admin/config/content/sidenotes`).
4. Enable the filter on the desired text format: Configuration → Content authoring → Text formats and editors. Edit your format and enable “Sidenotes (Tufte-style)”. Place it after “Limit allowed HTML” and “Convert line breaks”.

## Authoring

- Shortcode: `[sn]Your sidenote content[/sn]`
- Double parentheses: `((Your sidenote content))`

To make a specific note unnumbered, prefix the content with the configured marker (default `!@`). Unnumbered notes show the symbol in-text only, not inside the note header:

`[sn]!@This note is unnumbered[/sn]`

To use a specific symbol for one note, wrap a code with the configured prefix/suffix (default `!code!`). Examples:

- `[sn]!ast!Asterisk symbol note[/sn]`
- `[sn]!d!Dagger symbol note[/sn]`
- `[sn]!dd!Double dagger note[/sn]`
- `[sn]!delta!Delta symbol note[/sn]`

Both syntaxes can be enabled/disabled in settings. Notes render next to the reference on wide screens. On mobile they either show inline or are moved to an endnotes section (based on settings).

## Theming

The filter wraps processed content with:

```html
<div class="sn-container sn-margin-right sn-mobile-endnotes sn-numbered"
     data-sn-numbered="1"
     data-sn-placement="right"
     data-sn-mobile="endnotes"
     data-sn-breakpoint="768">
  <div class="sn-content">
    ... your content with <sup class="sn-ref"> and <span class="sn-note"> ...
  </div>
</div>
```

Key classes/variables:
- `.sn-container`, `.sn-content`: Layout scope.
- `.sn-margin-right` / `.sn-margin-left`: Margin placement.
- `.sn-numbered` / `.sn-symbols` / `.sn-unnumbered`: Label style.
  - When Custom is active, `.sn-symbols` is not present; the note header shows your custom label and the in-text reference shows your configured inline symbol.
- `.sn-note`, `.sn-note-number`, `.sn-note-content`: Note elements.
- `.sn-endnotes`, `.sn-endnotes-list`, `.sn-endnote`: Endnotes rendering.
- CSS variables: `--sn-margin-width` (default 18rem), `--sn-gap` (default 1rem), `--sn-color`, `--sn-divider`.

You can also set `margin_width` and `gap` in the settings UI to override variables globally (add them in your theme too for full control). The “Symbol options” section lets you customize the symbol sequence, code markers, and code→symbol mapping.
The endnotes section title is configurable in settings.

## Accessibility

- References are `<sup>` with a link targeting the note.
- Endnotes include a backreference (↩) to return to the inline reference.

## Notes on filter order

Place this filter after sanitizing filters so the injected markup is not stripped. Typical order: Limit allowed HTML → Convert line breaks → Sidenotes (Tufte-style).

## Alternatives and Extensibility

This module implements a text filter approach. Other viable options (choose based on workflow):

- Markdown footnotes: If you use a Markdown filter that supports footnotes (e.g., CommonMark), you can adapt its output with CSS or a tiny post-processing filter to re-style them as margin notes instead of endnotes.
- CKEditor widget: Add a CKEditor 5 plugin/button that inserts `[sn]` markup or wraps a selection with a `.sn-note` span. Good for WYSIWYG authors who prefer buttons; heavier to maintain.
- Field formatter: Create a custom field formatter that scans the rendered field for markers and decorates it with sidenote markup at render time, bypassing the text filter system.
- Twig filter/preprocess: Write a Twig filter (`{{ body|sidenotes }}`) or a `hook_preprocess_field()` that transforms the body render array. Useful if you don’t want to expose a text filter option to editors.

## Known limitations

- Nested `[sn]` inside another `[sn]` is not supported.
- If you paginate or use multiple body fields, numbering resets per processed field, which is usually desired.
- Ensure your theme width supports the margin column (space is reserved by `.sn-content` margins).

## Uninstall

Disable the module and remove the directory.

***

## Why this design

- Filter-based parsing keeps authoring simple and format-driven.
- Float-based margin layout is robust across themes and doesn’t require complex grid wrappers.
To use a specific custom label for one note (regardless of label style), use its configured override marker (e.g., `!wik!`). In-text, a configurable inline symbol is shown (default `✶`), while the note header shows the custom label.
- JS handles only the mobile endnote move, keeping the desktop experience CSS-only.
