<?php

namespace Drupal\simple_crop\Plugin\Field\FieldType;

use Drupal\image\Plugin\Field\FieldType\ImageItem;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Plugin implementation of the 'simple_crop' field type.
 *
 * @FieldType(
 *   id = "simple_crop",
 *   label = @Translation("Simple Crop Image"),
 *   description = @Translation("Image field with crop support."),
 *   default_widget = "simple_crop_widget",
 *   default_formatter = "image"
 * )
 */
class SimpleCropItem extends ImageItem {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = parent::propertyDefinitions($field_definition);

    $properties['crop_x'] = DataDefinition::create('integer')->setLabel(t('Crop X'));
    $properties['crop_y'] = DataDefinition::create('integer')->setLabel(t('Crop Y'));
    $properties['crop_width'] = DataDefinition::create('integer')->setLabel(t('Crop Width'));
    $properties['crop_height'] = DataDefinition::create('integer')->setLabel(t('Crop Height'));
    $properties['processed'] = DataDefinition::create('boolean')->setLabel(t('Processed'));
    $properties['derivative_uri'] = DataDefinition::create('string')->setLabel(t('Cropped image URI'));

    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    $schema = parent::schema($field_definition);
    $schema['columns']['crop_x'] = ['type' => 'int', 'unsigned' => TRUE, 'default' => 0];
    $schema['columns']['crop_y'] = ['type' => 'int', 'unsigned' => TRUE, 'default' => 0];
    $schema['columns']['crop_width'] = ['type' => 'int', 'unsigned' => TRUE, 'default' => 0];
    $schema['columns']['crop_height'] = ['type' => 'int', 'unsigned' => TRUE, 'default' => 0];
    $schema['columns']['processed'] = ['type' => 'int', 'size' => 'tiny', 'unsigned' => TRUE, 'default' => 0];
    $schema['columns']['derivative_uri'] = ['type' => 'varchar', 'length' => 255, 'not null' => FALSE];
    return $schema;
  }

  /**
   * {@inheritdoc}
   */
  public static function defaultFieldSettings() {
    return [
      'aspect_x' => 390,
      'aspect_y' => 280,
    ] + parent::defaultFieldSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function fieldSettingsForm(array $form, FormStateInterface $form_state): array {
    $element = [];

    $element['aspect_x'] = [
      '#type' => 'number',
      '#title' => $this->t('Aspect X'),
      '#default_value' => $this->getFieldSetting('aspect_x') ?? $this->getDefaultSettings()['aspect_x'],
      '#min' => 1,
      '#required' => TRUE,
      '#description' => $this->t('Horizontal ratio component (e.g. 390).'),
    ];

    $element['aspect_y'] = [
      '#type' => 'number',
      '#title' => $this->t('Aspect Y'),
      '#default_value' => $this->getFieldSetting('aspect_y') ?? $this->getDefaultSettings()['aspect_y'],
      '#min' => 1,
      '#required' => TRUE,
      '#description' => $this->t('Vertical ratio component (e.g. 280).'),
    ];

    return $element;
  }

}

