<?php

namespace Drupal\simple_crop\EventSubscriber;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\file\Entity\File;
use Drupal\simple_crop\SimpleCropProcessor;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Drupal\hook_event_dispatcher\Event\Entity\EntityPresaveEvent;
use Drupal\hook_event_dispatcher\Event\Entity\EntityHookEvents;


/**
 * Handles auto-processing of crop fields on entity save.
 */
class SimpleCropSubscriber implements EventSubscriberInterface {

  protected SimpleCropProcessor $processor;
  protected EntityTypeManagerInterface $entityTypeManager;

  public function __construct(SimpleCropProcessor $processor, EntityTypeManagerInterface $entityTypeManager) {
    $this->processor = $processor;
    $this->entityTypeManager = $entityTypeManager;
  }

  public static function getSubscribedEvents(): array {
    return [
      'hook_event_dispatcher.entity_presave' => 'onEntityPresave',
    ];
  }

  public function onEntityPresave(EntityPresaveEvent $event): void {
    $entity = $event->getEntity();
    if (!$entity->hasFieldDefinitions()) {
      return;
    }

    foreach ($entity->getFieldDefinitions() as $field_name => $definition) {
      if ($definition->getType() !== 'simple_crop') {
        continue;
      }

      $items = $entity->get($field_name);
      foreach ($items as $item) {
        if (!$item->isEmpty() && empty($item->processed) && $item->target_id) {
          $file = File::load($item->target_id);
          if (!$file instanceof File) {
            continue;
          }

          $crop_data = [
            'x' => (int) $item->crop_x,
            'y' => (int) $item->crop_y,
            'width' => (int) $item->crop_width,
            'height' => (int) $item->crop_height,
          ];

          $output_size = [
            'width' => (int) $definition->getSetting('aspect_x'),
            'height' => (int) $definition->getSetting('aspect_y'),
          ];

          $uri = $this->processor->process($file, $crop_data, $output_size);

          if ($uri) {
            $item->derivative_uri = $uri;
            $item->processed = TRUE;
          }
        }
      }
    }
  }

}

