<?php

namespace Drupal\simple_crop\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\image\Plugin\Field\FieldWidget\ImageWidget;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the 'simple_crop_widget' widget.
 *
 * @FieldWidget(
 *   id = "simple_crop_widget",
 *   label = @Translation("Simple crop widget"),
 *   field_types = {
 *     "simple_crop"
 *   }
 * )
 */
class SimpleCropWidget extends ImageWidget {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element = parent::formElement($items, $delta, $element, $form, $form_state);

    $field_settings = $this->getFieldSettings();
    $field_name = $this->fieldDefinition->getName();
    $element['#attached']['library'][] = 'simple_crop/widget';
    $element['#attached']['drupalSettings']['simpleCrop'][$field_name] = [
      'aspect_x' => $field_settings['aspect_x'] ?? 390,
      'aspect_y' => $field_settings['aspect_y'] ?? 280,
    ];

    $item = $items[$delta];

    // Add crop fields.
    $element['crop_x'] = [
      '#type' => 'hidden',
      '#default_value' => $item->crop_x ?? 0,
    ];
    $element['crop_y'] = [
      '#type' => 'hidden',
      '#default_value' => $item->crop_y ?? 0,
    ];
    $element['crop_width'] = [
      '#type' => 'hidden',
      '#default_value' => $item->crop_width ?? 0,
    ];
    $element['crop_height'] = [
      '#type' => 'hidden',
      '#default_value' => $item->crop_height ?? 0,
    ];

    // Add a .simple-crop class to the widget container for targeting.
    $element['#wrapper_attributes']['class'][] = 'simple-crop';

    return $element;
  }

}

