(function ($, Drupal) {
  Drupal.behaviors.simpleFavsBlockRender = {
    attach: function (context, settings) {
      once('simple-favs-render', '[data-block-plugin-id="simple_favs_block"], [data-block-plugin-id="simple-favs-block"]', context).forEach(function (block) {
        const $block = $(block);

        const use_db = drupalSettings.simple_favs.block?.use_db || 0;
        const uid = drupalSettings.simple_favs.block?.current_uid || 0;
        if (uid > 0 && use_db) {
          return;
        }
        const wrapper_prefix = drupalSettings.simple_favs.block.wrapper_prefix || '';
        const title_prefix = drupalSettings.simple_favs.block.title_prefix || '';
        const title_suffix = drupalSettings.simple_favs.block.title_suffix || '';
        const fallback_prefix = drupalSettings.simple_favs.block.fallback_prefix || '';
        const fallback_suffix = drupalSettings.simple_favs.block.fallback_suffix || '';
        const wrapper_suffix = drupalSettings.simple_favs.block.wrapper_suffix || '';
        const title_classes = drupalSettings.simple_favs.block.title_classes || '';
        const list_classes = drupalSettings.simple_favs.block.favs_list_classes || '';
        const langcode = drupalSettings.simple_favs.block.langcode || 'und';

        if ($block.length) {
          $block.empty();

          // Wait for both favs to resolve.
          Promise.all([
            Drupal.behaviors.simpleFavs.getFavs(),
            Drupal.behaviors.simpleFavs.getFavsOther()
          ]).then(([nodeFavs, otherFavs]) => {
            const nodeIds = Array.isArray(nodeFavs) ? nodeFavs : [];
            const hasOther = Array.isArray(otherFavs) && otherFavs.length > 0;

            const renderTitle = function () {
              const $titleHtml = $('<h2 class="simple-favs-block ' + title_classes + '">' + Drupal.t('My favourites') + '</h2>');
              return title_prefix + $titleHtml.prop('outerHTML') + title_suffix;
            };

            const wrapContent = function (html) {
              return wrapper_prefix || wrapper_suffix
                ? wrapper_prefix + html + wrapper_suffix
                : html;
            };

            if (nodeIds.length === 0 && !hasOther) {
              const fallbackHtml = fallback_prefix + '<p class="' + list_classes + '">' + Drupal.t("You don't have any favourites at the moment.") + '</p>' + fallback_suffix;
              $block.prepend(wrapContent(renderTitle() + fallbackHtml));
              return;
            }

            const $ul = $('<ul class="simple-favs-list ' + list_classes + '"></ul>');

            // Load node-based titles from backend
            $.getJSON('/simple-favs/titles', {
              ids: nodeIds,
              langcode: langcode,
            }, function (titleMap) {
              const max_items = drupalSettings.simple_favs.block?.max_items || 8;
              nodeIds.forEach(function (id) {
                if (!id || isNaN(id)) {
                  return;
                }

                const title = titleMap[id] || 'Content ID: ' + id;
                const url = (langcode !== 'und') ? '/' + langcode + '/node/' + id : '/node/' + id;

                const $item = $('<li></li>').append(
                  $('<a></a>').attr('href', url).text(title)
                );
                $ul.append($item);
              });

              // Add non-node favourites (views, taxonomy, etc.)
              otherFavs.forEach(function (entry) {
                const title = entry.title || entry.path;
                const path = entry.path;
                const $item = $('<li></li>').append(
                  $('<a></a>').attr('href', path).text(title)
                );
                $ul.append($item);
              });
              if ($ul.length) {
                $ul.find('li').each(function (index) {
                  if (index >= max_items) {
                    $(this).remove();
                  }
                });
                let manage_link_markup = drupalSettings.simple_favs.block?.manage_link_markup || '';
                const uid = drupalSettings.simple_favs.block?.current_uid || 0;
                if (!uid) {
                  manage_link_markup = '';
                }
                $ul.append($(manage_link_markup));
              }

              const $wrapped = $('<div></div>')
                .append(renderTitle())
                .append($ul);

              $block.prepend(wrapContent($wrapped.prop('outerHTML')));
            });
          });
        }
      });
    }
  };
})(jQuery, Drupal);

