(function ($, Drupal) {
  Drupal.behaviors.simpleFavsHeart = {
    attach: function (context, settings) {
      once('simple-favs-heart', '.simple-favs-heart', context).forEach(function (element) {
        const $heart = $(element);
        const contentId = parseInt($heart.data('id'));
        const title = document.title;
        const tooltip_add = settings.simple_favs?.heart?.tooltip_add;
        const tooltip_remove = settings.simple_favs?.heart?.tooltip_remove;
        const useFontawesome = drupalSettings.simple_favs?.heart?.fontawesome_enabled || false;

        function getIcon(active) {
          if (useFontawesome) {
            return active
              ? '<i class="fas fa-heart"></i>'
              : '<i class="far fa-heart"></i>';
          }
          return active ? '♥' : '♡';
        }

        function setVisual(isFavourite) {
          $heart
            .toggleClass('active', isFavourite)
            .attr({
              'aria-label': isFavourite ? tooltip_remove : tooltip_add,
              'title': isFavourite ? tooltip_remove : tooltip_add
            })
            .find('.heart-icon')
            .html(getIcon(isFavourite));
          // Immediately refresh the tooltip text if user is hovering.
          if ($heart.is(':hover')) {
            $heart.trigger('mouseleave').trigger('mouseenter');
          }
        }

        function updateVisual(forceState = null) {
          if (forceState !== null) {
            setVisual(forceState);
            return;
          }

          const isPromise = (!isNaN(contentId) && contentId > 0)
            ? Drupal.behaviors.simpleFavs.isInFavs(contentId)
            : Drupal.behaviors.simpleFavs.isInFavsOther();

          isPromise.then(setVisual);
        }

        function toggleFavourite() {
          const hasContentId = typeof contentId === 'number' && !isNaN(contentId) && contentId > 0;

          if (hasContentId) {
            Drupal.behaviors.simpleFavs.isInFavs(contentId).then((isFav) => {
              if (isFav) {
                Drupal.behaviors.simpleFavs.removeFromFavs(contentId);
                updateVisual(false);
              }
              else {
                Drupal.behaviors.simpleFavs.addToFavs(contentId);
                updateVisual(true);
              }
            });
          }
          else {
            // Only fallback to "other" if contentId was never properly detected
            Drupal.behaviors.simpleFavs.isInFavsOther().then((isFav) => {
              if (isFav) {
                Drupal.behaviors.simpleFavs.removeFromFavsOther();
                updateVisual(false);
              }
              else {
                Drupal.behaviors.simpleFavs.addToFavsOther(title);
                updateVisual(true);
              }
            });
          }
        }

        // Initialize visual state.
        updateVisual();

        // Mouse click toggle.
        $heart.on('click', function (event) {
          event.preventDefault();
          toggleFavourite();
        });

        // Key press toggle (Enter or Space).
        $heart.on('keydown', function (event) {
          if (event.key === 'Enter' || event.key === ' ') {
            event.preventDefault();
            toggleFavourite();
          }
        });
      });
    }
  };
})(jQuery, Drupal);

