(function ($, Drupal) {
  Drupal.behaviors.simpleFavsManagePage = {
    attach(context, settings) {
      once('simple-favs-manage', '#simple-favs-manage', context).forEach(() => {
        const container = document.querySelector('#simple-favs-manage');
        const list = container.querySelector('.simple-favs-list');
        const useDatabase =
          drupalSettings.simple_favs?.manage?.use_database_storage ?? false;
        const uid = parseInt(
          drupalSettings.simple_favs?.manage?.current_uid ?? 0
        );

        let favs = [];

        function render() {
          list.innerHTML = '';

          favs.forEach((fav, index) => {
            const li = document.createElement('li');

            const input = document.createElement('input');
            input.type = 'text';
            input.value = fav.title;
            input.className = 'form-control';
            input.disabled = true;
            input.style = 'visibility: hidden; max-width: 0px; padding: 0; float: right;';

            input.addEventListener('focus', () => {
              input.disabled = false;
            });

            input.addEventListener('blur', () => {
              input.disabled = true;
              favs[index].title = input.value;
              settings.simple_favs.manage.favs = favs;
              save();
            });

            const link = document.createElement('a');
            link.href = fav.path;
            link.innerText = (fav.title || '').slice(0, 150);
            link.title = fav.title;
            link.style.marginRight = '10px';

            const btn = document.createElement('button');
            btn.className = 'btn btn-danger btn-sm';
            btn.innerText = Drupal.t('Delete');
            btn.addEventListener('click', () => {
              favs.splice(index, 1);
              settings.simple_favs.manage.favs = favs;
              if (!useDatabase || uid === 0) {
                // @todo update cookie storage for anonymous users.
                render();
              }
              else {
                save();
              }
            });

            li.appendChild(btn);
            li.appendChild(link);
            li.appendChild(input);
            li.appendChild(document.createTextNode(' '));

            list.appendChild(li);
          });
        }

        function save() {
          list.querySelectorAll('input').forEach(input => input.disabled = true);

          if (useDatabase && uid !== 0) {
            fetch('/simple-favs/save-titles', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
              },
              body: JSON.stringify({ favourites: favs })
            }).then(() => {
              render();
            });
          }
          else {
            render();
          }
        }

        // Initial load.
        if (useDatabase && uid !== 0) {
          favs = settings.simple_favs.manage?.favs || [];
          render();
        }
        else {
          // Anonymous mode: combine node favs and 'other' favs.
          Promise.all([
            Drupal.behaviors.simpleFavs.getFavs(),        // returns array of NIDs
            Drupal.behaviors.simpleFavs.getFavsOther()    // returns array of { path, title }
          ]).then(([nodeIds, otherFavs]) => {
            const langcode = drupalSettings.simple_favs.manage.langcode || 'en';

            if (Array.isArray(nodeIds) && nodeIds.length) {
              $.getJSON('/simple-favs/titles', {
                ids: nodeIds,
                langcode: langcode
              }, (titleMap) => {
                const nodeFavs = nodeIds.map(nid => ({
                  path: `/${langcode}/node/${nid}`,
                  title: titleMap[nid] || `Node ${nid}`
                }));

                favs = nodeFavs.concat(otherFavs);
                settings.simple_favs.manage.favs = favs;
                render();
              });
            }
            else {
              favs = otherFavs;
              settings.simple_favs.manage.favs = favs;
              render();
            }
          });
        }
      });
    }
  };
})(jQuery, Drupal);

