(function ($, Drupal) {
  Drupal.behaviors.simpleFavsViewsHeart = {
    attach: function (context, settings) {
      once('views-simple-favs', '.views-heart', context).forEach(function (element) {
        const $heart = $(element);
        const contentId = parseInt($heart.data('id'));
        const tooltip_add = settings.simple_favs?.views_heart?.tooltip_add;
        const tooltip_remove = settings.simple_favs?.views_heart?.tooltip_remove;
        const useFontawesome = settings.simple_favs.views_heart?.fontawesome_enabled || false;
        const $row = $heart.closest('.views-row');
        const $anchor = $row.find('a').first();
        // We'll resolve title server-side based on path.
        const path = getNormalizedPath($anchor.attr('href').trim());

        function getNormalizedPath(href) {
          const front_path = settings.simple_favs?.views_heart?.front_path || '/';
          const front_raw = settings.simple_favs?.views_heart?.front_raw || '';
          const front_scheme_domain = settings.simple_favs?.views_heart?.front_scheme_and_domain || '';

          // Normalize to internal path
          let normalized = href;

          // Strip full domain
          if (normalized.startsWith(front_scheme_domain)) {
            normalized = normalized.substring(front_scheme_domain.length);
          }

          // Ensure it starts with the front path (like /en or /fr)
          if (!normalized.startsWith(front_path)) {
            normalized = front_path + normalized;
          }

          // Remove trailing slash for consistency
          return normalized.replace(/\/+$/, '');
        }

        function toggleFavourite() {
          if (!isNaN(contentId) && contentId > 0) {
            Drupal.behaviors.simpleFavs.isInFavs(contentId).then((isFav) => {
              if (isFav) {
                Drupal.behaviors.simpleFavs.removeFromFavs(contentId);
                updateVisual(false);
              }
              else {
                Drupal.behaviors.simpleFavs.addToFavs(contentId);
                updateVisual(true);
              }
            });
          }
          else {
            Drupal.behaviors.simpleFavs.isInFavsOtherViews(path).then((isFav) => {
              if (isFav) {
                Drupal.behaviors.simpleFavs.removeFromFavsOther();
                updateVisual(false);
              }
              else {
                Drupal.behaviors.simpleFavs.addToFavsOtherFromViews(path);
                updateVisual(true);
              }
              updateVisual();
            });
          }
        }

        function updateVisual(forceState = null) {
          if (forceState !== null) {
            setVisual(forceState);
            return;
          }

          const isPromise = (!isNaN(contentId) && contentId > 0)
            ? Drupal.behaviors.simpleFavs.isInFavs(contentId)
            : Drupal.behaviors.simpleFavs.isInFavsOtherViews(path);

          isPromise.then(setVisual);
        }

        function getIcon(active) {
          if (useFontawesome) {
            return active
              ? '<i class="fas fa-heart"></i>'
              : '<i class="far fa-heart"></i>';
          }
          return active ? '♥' : '♡';
        }

        function setVisual(isFavourite) {
          $heart
            .toggleClass('active', isFavourite)
            .attr({
              'aria-label': isFavourite ? tooltip_remove : tooltip_add,
              'title': isFavourite ? tooltip_remove : tooltip_add
            })
            .find('.heart-icon')
            .html(getIcon(isFavourite));
          // Immediately refresh the tooltip text if user is hovering.
          if ($heart.is(':hover')) {
            $heart.trigger('mouseleave').trigger('mouseenter');
          }
        }

        // Initialize visual state.
        updateVisual();

        // Mouse click toggle.
        $heart.on('click', function (event) {
          event.preventDefault();
          toggleFavourite();
        });

        // Key press toggle (Enter or Space).
        $heart.on('keydown', function (event) {
          if (event.key === 'Enter' || event.key === ' ') {
            event.preventDefault();
            toggleFavourite();
          }
        });
      });
    }
  };
})(jQuery, Drupal);

