<?php

use Drupal\views\ViewExecutable;
use Drupal\views\Plugin\views\display\DisplayPluginBase;

/**
 * Implements hook_views_data().
 */
function simple_favs_views_data() {
  $data = [];

  $data['node']['simple_favs_heart_field'] = [
    'title' => t('Simple Favourite Heart'),
    'help' => t('Displays a heart icon for favourites.'),
    'field' => [
      'id' => 'simple_favs_views_heart',
      'real field' => 'nid', // This tells Views to get `node.nid`.
      'click sortable' => FALSE,
    ],
  ];

  $search_api_installed = \Drupal::moduleHandler()->moduleExists('search_api');
  if ($search_api_installed) {
    $bases = [];
    foreach (Drupal\search_api\Entity\Index::loadMultiple() as $index) {
      $data['search_api_index_' . $index->id()]['simple_favs_heart_field'] = [
        'title' => t('Simple Favourite Heart'),
        'help' => t('Displays a heart icon for favourites.'),
        'field' => [
          'id' => 'simple_favs_views_heart',
            'real field' => 'nid',
            'click sortable' => FALSE,
        ],
      ];
    }
  }

  return $data;
}


