<?php

namespace Drupal\simple_favs\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\node\NodeInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Language\LanguageManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

class SimpleFavsController extends ControllerBase {

  protected $entityTypeManager;

  public function __construct(EntityTypeManagerInterface $entityTypeManager) {
    $this->entityTypeManager = $entityTypeManager;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('entity_type.manager')
    );
  }

  public function getTitles(Request $request) {
    $ids = $request->query->all('ids');
    $langcode = $request->query->get('langcode', 'en'); // default to English
    $titles = [];

    if (!is_array($ids) || empty($ids)) {
      return new JsonResponse($titles);
    }

    $query = $this->entityTypeManager->getStorage('node')->getQuery();
    $query->accessCheck(TRUE)
      ->condition('status', 1)
      ->condition('nid', $ids, 'IN');

    $result_ids = $query->execute();
    $nodes = $this->entityTypeManager->getStorage('node')->loadMultiple($result_ids);

    foreach ($nodes as $node) {
      if ($node instanceof NodeInterface) {
        if ($node->hasTranslation($langcode)) {
          $titles[$node->id()] = $node->getTranslation($langcode)->label();
        }
        else {
          $titles[$node->id()] = $node->label();
        }
      }
    }

    return new JsonResponse($titles);
  }

}

