<?php

namespace Drupal\simple_otp\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Simple OTP settings.
 */
class SimpleOtpSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'simple_otp_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['simple_otp.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('simple_otp.settings');

    $form['otp_length'] = [
      '#type' => 'number',
      '#title' => $this->t('OTP Length'),
      '#default_value' => $config->get('otp_length'),
      '#min' => 4,
      '#max' => 6,
      '#required' => TRUE,
    ];

    $form['expiry_time'] = [
      '#type' => 'number',
      '#title' => $this->t('OTP Expiry Time (minutes)'),
      '#default_value' => $config->get('expiry_time'),
      '#min' => 1,
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('simple_otp.settings')
      ->set('otp_length', $form_state->getValue('otp_length'))
      ->set('expiry_time', $form_state->getValue('expiry_time'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}