<?php

declare(strict_types=1);

namespace Drupal\simple_sitemap_diwoo\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\simple_sitemap\Controller\SimpleSitemapController;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Returns responses for Simple Sitemap DiWoo routes.
 */
class SimpleSitemapDiwooController extends ControllerBase {

  /**
   * SimpleSitemapDiwooController constructor.
   *
   * @param \Drupal\simple_sitemap\Controller\SimpleSitemapController $sitemapController
   *   The simple_sitemap controller which renders a sitemap.
   */
  public function __construct(protected SimpleSitemapController $sitemapController) {}

  /**
   * Creates the controller.
   *
   * @param \Symfony\Component\DependencyInjection\ContainerInterface $container
   *   The container.
   *
   * @return static
   *   The created SimpleSitemapDiwooController instance.
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('class_resolver')->getInstanceFromDefinition(SimpleSitemapController::class)
    );
  }

  /**
   * Builds the response.
   */
  public function __invoke(Request $request) {
    // Try to load and return the DiWoo index sitemap.
    $types = $this->entityTypeManager()
      ->getStorage('simple_sitemap_type')
      ->getQuery()
      ->condition('url_generators.*', 'diwoo_index')
      ->accessCheck(FALSE)
      ->execute();

    if (!$types) {
      return [];
    }

    $variants = $this->entityTypeManager()
      ->getStorage('simple_sitemap')
      ->getQuery()
      ->sort('weight')
      ->condition('type', reset($types))
      ->accessCheck(FALSE)
      ->execute();

    if (!$variants) {
      return [
        '#type' => 'html_tag',
        '#tag' => 'p',
        '#markup' => $this->t('No DiWoo Sitemap Index available.'),
      ];
    }

    // Get the default Sitemap view.
    return $this->sitemapController->getSitemap($request, reset($variants));
  }

}
