<?php

namespace Drupal\simple_sitemap_diwoo\Plugin\simple_sitemap\SitemapGenerator;

use Drupal\simple_sitemap\Plugin\simple_sitemap\SitemapGenerator\SitemapIndexGenerator;

/**
 * Provides the DiWoo sitemap index generator.
 *
 * @package Drupal\simple_sitemap\Plugin\simple_sitemap\SitemapGenerator
 *
 * @SitemapGenerator(
 *   id = "diwoo_index",
 *   label = @Translation("DiWoo Sitemap index generator"),
 *   description = @Translation("Generates an index of your DiWoo sitemaps."),
 * )
 */
class DiwooSitemapIndexGenerator extends SitemapIndexGenerator {

  protected const XMLNS_XSI = 'http://www.w3.org/2001/XMLSchema-instance';
  protected const XSI_SCHEMA_LOCATION =
    'https://www.sitemaps.org/schemas/sitemap/0.9 ' .
    'https://www.sitemaps.org/schemas/sitemap/0.9/siteindex.xsd';

  /**
   * An array of attributes.
   *
   * @var array
   */
  protected const ATTRIBUTES = [
    'xmlns' => self::XMLNS,
    'xmlns:sitemap' => self::XMLNS,
    'xmlns:xsi' => self::XMLNS_XSI,
    'xsi:schemaLocation' => self::XSI_SCHEMA_LOCATION,
  ];

  /**
   * Generates and returns a sitemap chunk.
   *
   * @param array $links
   *   All links with their multilingual versions and settings.
   *
   * @return string
   *   Sitemap chunk
   */
  public function getChunkContent(array $links): string {
    // We keep it clean so now generated by or styling.
    $this->writer->openMemory();
    $this->writer->setIndent(TRUE);
    $this->writer->startSitemapDocument();

    $this->writer->startElement('sitemapindex');
    $this->addSitemapAttributes();
    $this->addLinks($links);
    $this->writer->endElement();
    $this->writer->endDocument();

    return $this->writer->outputMemory();
  }

  /**
   * Adds attributes to the sitemap.
   */
  protected function addSitemapAttributes(): void {
    $attributes = self::ATTRIBUTES;
    $this->moduleHandler->alter('simple_sitemap_attributes', $attributes, $this->sitemap);
    foreach ($attributes as $name => $value) {
      $this->writer->writeAttribute($name, $value);
    }
  }

}
