<?php

namespace Drupal\simple_sitemap_diwoo\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'diwoo_boolean_formatter' formatter.
 */
#[FieldFormatter(
  id: 'diwoo_formatter',
  label: new TranslatableMarkup('DiWoo indexed boolean'),
  field_types: ['diwoo_meta']
)]
class DiwooFormatter extends FormatterBase {
  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = [
        '#markup' => empty($item->indexed) ? $this->t('No') : $this->t('Yes'),
      ];
    }

    return $elements;
  }

}
