<?php

namespace Drupal\simple_sitemap_diwoo\Plugin\simple_sitemap\UrlGenerator;

use Drupal\simple_sitemap\Plugin\simple_sitemap\UrlGenerator\SitemapIndexUrlGenerator;

/**
 * Class VariantIndexUrlGenerator.
 *
 * @package Drupal\simple_sitemap\Plugin\simple_sitemap\UrlGenerator
 *
 * @UrlGenerator(
 *   id = "diwoo_index",
 *   label = @Translation("DiWoo Sitemap URL generator"),
 *   description = @Translation("Generates Diwoo sitemap URLs for a sitemap index."),
 * )
 */
class DiwooSitemapIndexUrlGenerator extends SitemapIndexUrlGenerator {

  /**
   * {@inheritdoc}
   */
  public function getDataSets(): array {
    // Filter the sitemaps so only diwoo sitemaps are used.
    $types = \Drupal::entityTypeManager()
      ->getStorage('simple_sitemap_type')
      ->getQuery()
      ->condition('sitemap_generator', 'diwoo')
      ->accessCheck(FALSE)
      ->execute();

    if (!$types) {
      return [];
    }

    return \Drupal::entityTypeManager()
      ->getStorage('simple_sitemap')
      ->getQuery()
      ->condition('type', reset($types))
      ->sort('weight')
      ->accessCheck(FALSE)
      ->execute();
  }

}
