## CONTENTS OF THIS FILE

- Introduction
- Installation
- Configuration
- Usage
- How Can You Contribute?
- Maintainers

---

## INTRODUCTION

**Author and maintainer**: Erwin van Brandwijk
([erwinvb][link-erwinvb])

This module is an extension of the [Simple Sitemap][link-simple-sitemap] module.
It generates a **DiWoo-compliant XML sitemap** based on
[XSD definitions][link-xsd].
The sitemap includes URLs to files, enriched with metadata according to the
DiWoo standards.

---

## INSTALLATION

Install this module as you would any other Drupal module.
Refer to the [Drupal documentation][link-d] for guidance.

---

## CONFIGURATION

This module introduces a new field type: `diwoo_meta`, which can be added to
**media entities**.

You must also configure which **file reference field** should be used.
The selected field will be used to extract the file link and include it in the
sitemap, along with the additional metadata.

---

### PERMISSIONS

This module uses the same permissions as the Simple Sitemap module.
They can be configured at:
`/admin/people/permissions#module-simple_sitemap`

---

### SITEMAPS

The module provides both a `SitemapGenerator` and a `UrlGenerator`.

You can register a new sitemap type at:
`/admin/config/search/simplesitemap/types`
Choose:
- **Sitemap Generator**: "DiWoo Sitemap Generator"
- **URL Generator**: "DiWoo Media URL Generator"

Now you should add a sitemap index which automatically gets the name convention.
Choose:
- **Sitemap Generator**: "DiWoo Sitemap Index Generator"
- **URL Generator**: "DiWoo Sitemap URL Generator"

After creating the sitemap types, add the new sitemap variants via:
`/admin/config/search/simplesitemap/variants/add`
And select the newly created types.

---

## USAGE

After adding the `diwoo_meta` field to a media entity type, a form widget will
be available. This allows you to enable indexing for individual media entities.

You can use **tokens** in the metadata fields, and set **default values** via:
`/admin/config/search/simplesitemap/diwoo-settings`
These default values will be merged during sitemap generation.

---

## HOW CAN YOU CONTRIBUTE?

- Report issues or feature requests on the module’s Drupal.org issue queue.
- Create merge requests or patches with improvements.
- Share feedback and ideas — all input is welcome!

---

## MAINTAINERS

Current maintainer:
- **Erwin van Brandwijk** ([erwinvb][link-erwinvb])

---

[link-erwinvb]: https://www.drupal.org/u/erwinvb
[link-simple-sitemap]: https://www.drupal.org/project/simple_sitemap
[link-xsd]: https://standaarden.overheid.nl/diwoo/metadata/diwoo-handleiding
[link-d]: https://www.drupal.org/documentation/install/modules-themes/modules-8
