<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9">
  <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
  <xsl:template match="/">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <title>XML Sitemap</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <style type="text/css">
          body {
            font-family: Arial, sans-serif;
            font-size: 14px;
            margin: 20px;
            background-color: #f5f5f5;
            color: #333;
          }
          .header {
            background-color: #fff;
            padding: 20px;
            border: 1px solid #ddd;
            margin-bottom: 20px;
          }
          .header h1 {
            margin: 0 0 10px 0;
            color: #333;
            font-size: 24px;
          }
          .header p {
            margin: 0;
            color: #666;
          }
          .info {
            background-color: #fff;
            padding: 15px;
            border: 1px solid #ddd;
            margin-bottom: 20px;
          }
          .url-count {
            font-weight: bold;
            color: #333;
          }
          .url-list {
            background-color: #fff;
            border: 1px solid #ddd;
          }
          .url-item {
            padding: 10px;
            border-bottom: 1px solid #eee;
          }
          .url-item:last-child {
            border-bottom: none;
          }
          .url-link {
            color: #0066cc;
            text-decoration: none;
            font-weight: bold;
            display: block;
            margin-bottom: 5px;
          }
          .url-link:hover {
            text-decoration: underline;
          }
          .url-meta {
            font-size: 12px;
            color: #666;
          }
          .url-meta span {
            margin-right: 15px;
          }
          .note {
            background-color: #fff;
            border: 1px solid #ddd;
            padding: 15px;
            margin-top: 20px;
            color: #666;
            font-size: 12px;
          }
        </style>
      </head>
      <body>
        <div class="header">
          <h1>XML Sitemap</h1>
          <p>This sitemap contains <xsl:value-of select="count(sitemap:urlset/sitemap:url)"/> URLs</p>
        </div>

        <div class="info">
          <span class="url-count">Total URLs: <xsl:value-of select="count(sitemap:urlset/sitemap:url)"/></span>
        </div>

        <div class="url-list">
          <xsl:for-each select="sitemap:urlset/sitemap:url">
            <div class="url-item">
              <a class="url-link" href="{sitemap:loc}">
                <xsl:value-of select="sitemap:loc"/>
              </a>
              <div class="url-meta">
                <span>Last modified: <xsl:value-of select="sitemap:lastmod"/></span>
                <span>Change frequency: <xsl:value-of select="sitemap:changefreq"/></span>
                <span>Priority: <xsl:value-of select="sitemap:priority"/></span>
              </div>
            </div>
          </xsl:for-each>
        </div>

        <div class="note">
          This XML sitemap is used to help search engines like Google better crawl and index your site.
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
