# Changelog

All notable changes to this project will be documented in this file.

## [1.1.0] - 2025-11-07

### Added
- **Content Type-based sitemap generation**: New primary generation mode that creates sitemaps directly from content types
- **Node status filtering**: Option to include published, unpublished, or both types of nodes
- **Enhanced priority system**: Support for content type-specific priorities
- **Individual node lastmod timestamps**: Uses actual node changed time instead of generation time
- **Content type configuration**: Dedicated settings section for content type selection and priorities
- **Mixed priority mode**: Combines content type, custom URL, and menu level priorities
- **Entity type manager integration**: Proper node loading and URL generation
- **Homepage priority handling**: Special handling for homepage URLs with highest priority option

### Changed
- **Default generation mode**: Changed from menu-based to content type-based generation
- **Configuration form**: Reorganized with tabbed sections for different generation modes
- **Priority assignment**: Content type priority mode is now the default
- **XSL stylesheet URL**: Simplified stylesheet URL generation
- **Legacy support**: Menu-based generation moved to "legacy" section but fully supported

### Enhanced
- **Cache key differentiation**: Separate cache keys for different generation modes
- **URL validation**: Improved URL exclusion logic with better pattern matching
- **Form validation**: Added comprehensive validation for content type priorities
- **Error handling**: Better exception handling for node URL generation
- **Performance**: Optimized node loading and URL generation process

### Technical Improvements
- Added EntityTypeManagerInterface and NodeInterface imports
- Enhanced constructor with entity type manager dependency injection
- Improved XML generation with node-specific timestamps
- Better separation of concerns between menu and content type generation
- Enhanced priority calculation logic with content type support

## [1.0.0] - 2025-10-21

### Added
- Initial release of Simple Sitemap XML module
- Menu-based sitemap generation
- Multiple priority assignment modes:
  - Default priority for all URLs
  - Automatic priority based on menu hierarchy level
  - Custom priorities for specific URLs
  - Mixed mode combining both approaches
- URL exclusion with wildcard support
- Built-in caching system (1 hour default)
- Visual presentation with XSL stylesheet
- Homepage inclusion option
- Standards compliant XML output
- Configuration form with validation
- Cache clearing functionality
- Support for Drupal 9, 10, and 11

### Features
- Intelligent priority assignment based on menu depth
- Flexible URL pattern matching with wildcards
- Responsive visual interface for human viewing
- Automatic cache invalidation on configuration changes
- Access control integration with Drupal permissions
- Error handling for invalid menus or URLs
- Clean, simple configuration interface
