# Simple Sitemap XML

## Description

A lightweight and flexible Drupal module that generates XML sitemaps based on menu structures. The module provides intelligent priority assignment, URL exclusion capabilities, and a clean visual interface for human-readable sitemaps.

## Features

- **Menu-based generation**: Generate sitemaps from any Drupal menu
- **Intelligent priority assignment**: Multiple priority modes including automatic menu-level priorities
- **URL exclusion**: Exclude specific URLs or patterns from the sitemap
- **Caching system**: Built-in caching for improved performance
- **Visual presentation**: Clean, responsive interface for human viewing while maintaining XML compatibility
- **Multiple priority modes**:
  - Default priority for all URLs
  - Automatic priority based on menu hierarchy level
  - Custom priorities for specific URLs
  - Mixed mode combining both approaches
- **Wildcard support**: Use patterns like `/admin/*` to exclude multiple URLs
- **Homepage inclusion**: Optional automatic inclusion of the homepage
- **Standards compliant**: Generates XML sitemaps compatible with sitemaps.org standards

## Installation

1. Download and place the module in your `modules/custom` or `modules/contrib` directory
2. Enable the module via the admin interface or using Drush:
   ```bash
   drush en simple_sitemap_xml
   ```

## Configuration

Navigate to **Administration > Configuration > Search and metadata > Simple Sitemap XML** to configure:

### Basic Settings
- **Menu selection**: Choose which menu to use as the source for sitemap generation
- **Include homepage**: Automatically include the homepage (/) in the sitemap
- **Base URL**: Custom base URL (optional, defaults to current site URL)

### URL Exclusion
Add URLs to exclude from the sitemap, one per line:
```
/admin
/admin/*
/user
/user/*
/search
/contact
```

### Priority Settings
Choose from four priority assignment modes:

#### 1. Default Priority
All URLs receive the same priority value.

#### 2. Menu Level Priority (Recommended)
Automatically assigns priorities based on menu hierarchy:
- Level 1 (main menu items): 1.0
- Level 2 (submenu items): 0.8
- Level 3 (sub-submenu items): 0.6
- Level 4+: 0.4

#### 3. Custom Priorities
Manually define priorities for specific URLs:
```
/|1.0
/about|0.8
/services|0.9
/blog/*|0.7
```

#### 4. Mixed Mode
Combines menu-level priorities with custom overrides. Custom priorities take precedence over automatic menu-level assignments.

## Usage

Once configured, the sitemap is automatically available at:
- `https://yoursite.com/sitemap.xml`

The sitemap will update automatically when:
- Configuration is changed
- Cache expires (1 hour by default)
- Manual cache clearing is performed

## URL Pattern Matching

The module supports flexible URL matching:

- **Exact paths**: `/about`
- **Full URLs**: `https://example.com/page`
- **Wildcard patterns**: `/blog/*` (matches all URLs starting with `/blog/`)

## Performance

- **Caching**: Sitemaps are cached for 1 hour to improve performance
- **Cache invalidation**: Automatic cache clearing when configuration changes
- **Manual cache clearing**: Available via configuration form
- **Efficient processing**: Only processes enabled menu items with proper access control

## Technical Details

- **Compatible with**: Drupal 9, 10, and 11
- **Dependencies**: menu_link_content, system (both included in Drupal core)
- **XML Standards**: Compliant with sitemaps.org protocol
- **Visual Presentation**: Uses XSL stylesheet for human-readable presentation
- **Access Control**: Respects Drupal's menu access control system

## Example Configuration

### Typical Setup
- **Menu**: Main navigation
- **Priority Mode**: Menu level priority
- **Include Homepage**: Yes
- **Change Frequency**: Weekly

### Common Exclusions
```
/admin
/admin/*
/user
/user/*
/search
/node/add
/node/add/*
```

### Custom Priority Examples
```
/|1.0
/products|0.9
/services|0.9
/about|0.8
/blog|0.7
/blog/*|0.6
/contact|0.5
```

## Support

For issues, feature requests, or contributions, please visit the module's project page on Drupal.org.

## License

This project is licensed under the GPL-2.0+ license - the same license as Drupal core.
