(function (Drupal) {
  "use strict";

  Drupal.behaviors.simpleSocialShare = {
    attach: function (context, settings) {
      once("simple-social-share", ".copy-link", context).forEach(function (
        button
      ) {
        button.addEventListener("click", function (e) {
          e.preventDefault();
          const url = this.dataset.url;
          // Create a temporary input element
          const input = document.createElement("input");
          input.value = url;
          document.body.appendChild(input);
          input.select();
          document.execCommand("copy");
          document.body.removeChild(input);
          // Visual feedback
          this.classList.add("copied");
          setTimeout(() => {
            this.classList.remove("copied");
          }, 2000);
          // Accessibility feedback
          Drupal.announce(Drupal.t("Link copied to clipboard"));
        });
      });
    },
  };
})(Drupal);
