<?php

namespace Drupal\simple_social_share\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Entity\EntityInterface;

/**
 * Controller for redirecting to nodes.
 */
class ShortLinkController extends ControllerBase {

  /**
   * Redirects to the node canonical page.
   *
   * @param \Drupal\Core\Entity\EntityInterface $node
   *   The node entity.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   Redirects to the node canonical.
   */
  public function redirectNode(EntityInterface $node) {
    return $this->redirect('entity.node.canonical', ['node' => $node->id()], [], 302);
  }

  /**
   * Redirects to the taxonomy term canonical page.
   *
   * @param \Drupal\Core\Entity\EntityInterface $taxonomy_term
   *   The taxonomy term entity.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   Redirects to the taxonomy term canonical.
   */
  public function redirectTaxonomyTerm(EntityInterface $taxonomy_term) {
    return $this->redirect('entity.taxonomy_term.canonical', ['taxonomy_term' => $taxonomy_term->id()], [], 302);
  }
}
