(function (Drupal) {
  "use strict";

  Drupal.behaviors.simpleSocialShare = {
    attach: function (context, settings) {
      once("simple-social-share", ".copy-link", context).forEach(function (
        button
      ) {
        button.addEventListener("click", function (e) {
          e.preventDefault();
          const url = this.dataset.url;
          const button = this;

          // Use modern Clipboard API with fallback
          if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(url).then(
              function () {
                // Visual feedback
                button.classList.add("copied");
                setTimeout(() => {
                  button.classList.remove("copied");
                }, 2000);
                // Accessibility feedback
                Drupal.announce(Drupal.t("Link copied to clipboard"));
              },
              function (err) {
                console.error("Failed to copy text: ", err);
              }
            );
          } else {
            // Fallback for older browsers
            const input = document.createElement("input");
            input.value = url;
            document.body.appendChild(input);
            input.select();
            try {
              document.execCommand("copy");
              // Visual feedback
              button.classList.add("copied");
              setTimeout(() => {
                button.classList.remove("copied");
              }, 2000);
              // Accessibility feedback
              Drupal.announce(Drupal.t("Link copied to clipboard"));
            } catch (err) {
              console.error("Failed to copy text: ", err);
            }
            document.body.removeChild(input);
          }
        });
      });
    },
  };
})(Drupal);
