# Simple Toasts

[![Drupal 9](https://img.shields.io/badge/Drupal-9-blue.svg)](https://www.drupal.org/project/drupal)
[![Drupal 10](https://img.shields.io/badge/Drupal-10-blue.svg)](https://www.drupal.org/project/drupal)
[![Drupal 11](https://img.shields.io/badge/Drupal-11-blue.svg)](https://www.drupal.org/project/drupal)

## CONTENTS OF THIS FILE

 * Introduction
 * Requirements
 * Installation
 * Configuration
 * Troubleshooting
 * Maintainers

## INTRODUCTION

Lightweight dependency-free module that replaces the standard Drupal status messages with "Toast" notifications (or alerts).

Works for all status/warning and error messages including messages created with Ajax and Drupal.Message() javascript calls.

- For a full description of the module, visit the [project page](https://www.drupal.org/project/simple_toasts).
- Use the [Issue queue](https://www.drupal.org/project/issues/simple_toasts) to submit bug reports and feature suggestions, or track changes.

## REQUIREMENTS

No additional libraries are required.

## INSTALLATION

composer require drupal/simple_toasts

## CONFIGURATION

* Navigate to Administration > Configuration > User Interface > Simple Toasts Settings
(/admin/config/user-interface/simple-toasts/settings)

## TROUBLESHOOTING

### Not seeing toast messages in a custom theme?

This module uses the data attribute 'data-drupal-messages' to identify the messages container. If you are using a custom theme, ensure that your status-messages.html.twig template has a container with this data attribute. For example:

```html
<div data-drupal-messages class="messages-list">
  <div class="messages__wrapper layout-container">
    <div class="status">...</div>
    <div class="warning">...</div>
    <div class="error">...</div>
  </div>
</div>
  ```

This is the same layout as used by Drupal core. e.g. in Olivero /core/themes/olivero/templates/misc/status-messages.html.twig


### Not seeing Javascript Message API messages?

In order for this module to capture Javascript Message API messages, you must ensure that you have not overridden the status messages render element with '#include_fallback' => FALSE. The #include_fallback property (when set to true) ensures there is a container element for JavaScript Message API to add messages. See https://www.drupal.org/node/3002643

## MAINTAINERS

* JimiOBrien - https://www.drupal.org/u/jimiobrien
