<?php

namespace Drupal\simple_toasts;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Extension\ThemeHandlerInterface;
use Drupal\Core\Theme\ThemeManager;
use Drupal\Core\Theme\ThemeManagerInterface;

class SimpleToastsHelper {

  /**
   * The configuration factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected ConfigFactoryInterface $configFactory;

  /**
   * The theme manager.
   *
   * @var \Drupal\Core\Theme\ThemeManagerInterface
   */
  protected ThemeManagerInterface $themeManager;

  /**
   * Constructs a SimpleToastsHelper object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The configuration factory.
   *
   * @param \Drupal\Core\Theme\ThemeManagerInterface $theme_manager
   *   The theme manager.
   */
  public function __construct(ConfigFactoryInterface $config_factory, ThemeManagerInterface $theme_manager) {
    $this->configFactory = $config_factory;
    $this->themeManager = $theme_manager;
  }

  /**
   * Gets the settings for the module.
   *
   * @return array
   *   The settings for the module.
   */
  public function getSettings(): array {
    return $this->configFactory->get('simple_toasts.settings')->getRawData();
  }

  public function getActiveThemeName(): string {
    return $this->themeManager->getActiveTheme()->getName();
  }

  public function getEnabledThemes(): array {
    return $this->configFactory->get('simple_toasts.settings')->get('themes');
  }

  public function themeIsEnabled(): bool|string {
    $enabled_themes = $this->getEnabledThemes();
    $active_theme = $this->getActiveThemeName();
    if(isset($enabled_themes[$active_theme])) {
      return $active_theme;
    }
    return FALSE;
  }

}
