<?php

namespace Drupal\simple_wt_metatags\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Defines the settings form for Simple WT Metatags module.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'simple_wt_metatags_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['simple_wt_metatags.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('simple_wt_metatags.settings');

    // --- Start: New Instructions for User ---
    $form['intro_instructions'] = [
      '#markup' => $this->t('<p>This module allows you to easily configure the Meta Description and Open Graph (OG) image for your "Node" and "Taxonomy term (View)" pages.<br>
        Below, enter the <strong>machine names</strong> of the fields you want to use.</p>
        <p><strong>Important:</strong></p>
        <ul>
          <li>For the Meta Description, add (or use an existing field) a <strong>"Text (plain, long)"</strong> field on your "Content type / Node" & "Vocabulary / Taxonomy term".</li>
          <li>For the Open Graph Image, add (or use an existing field) a <strong>"Media (image)"</strong> reference field on your "Content type / Node" & "Vocabulary / Taxonomy term".</li>
          <li>Ensure the fields you specify <strong>exist</strong> on your "Content type / Node" & "Vocabulary / Taxonomy term" and <strong>contain data</strong> for the metatags to appear.</li>
        </ul>
        <hr>'), // Add a horizontal rule for visual separation.
      '#weight' => -10, // Ensure it appears at the top of the form.
    ];
    // --- End: New Instructions for User ---

    $form['general_settings'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Metatag Field Configuration'),
      '#collapsible' => FALSE,
      '#collapsed' => FALSE,
    ];

    $form['general_settings']['description_field_machine_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Meta Description Field Machine Name'),
      '#description' => $this->t('Enter the machine name of the "Text (plain, long)" field. <br> Example: <em>field_summary</em>'),
      '#default_value' => $config->get('description_field_machine_name'),
      '#required' => FALSE,
      '#parents' => ['general_settings', 'description_field_machine_name'],
    ];

    $form['general_settings']['og_image_field_machine_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Open Graph Image Field Machine Name'),
      '#description' => $this->t('Enter the machine name of the image "Media (image)" reference field. <br> Example: <em>field_featured_image</em>'),
      '#default_value' => $config->get('og_image_field_machine_name'),
      '#required' => FALSE,
      '#parents' => ['general_settings', 'og_image_field_machine_name'],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $description_field_value = $form_state->getValue(['general_settings', 'description_field_machine_name'], '');
    $og_image_field_value = $form_state->getValue(['general_settings', 'og_image_field_machine_name'], '');

    $this->config('simple_wt_metatags.settings')
      ->set('description_field_machine_name', $description_field_value)
      ->set('og_image_field_machine_name', $og_image_field_value)
      ->save();

    parent::submitForm($form, $form_state);
  }

}