# Simple WT Metatags

## Introduction

The Simple WT Metatags module provides a lightweight and configurable solution for managing essential meta description and Open Graph (OG) image tags on your Drupal website.

Unlike comprehensive SEO modules, Simple WT Metatags focuses specifically on these two crucial metatags. It allows site builders to select existing fields on **node and taxonomy entities** to populate the `<meta name="description">` and `<meta property="og:image">` tags.

---

## Features

* **Configurable Meta Description:** Specify a text field (e.g., `field_summary`) on your node content types and taxonomy vocabularies to serve as the source for the HTML `<meta name="description">` tag.
* **Configurable Open Graph Image:** Select an image media reference field (e.g., `field_featured_image`) on your node content types and taxonomy vocabularies to be used for the Open Graph image (`<meta property="og:image">`).
* **Generates Related OG Tags:** Automatically creates related tags for the image, including `og:image:width`, `og:image:height`, `og:image:secure_url`, and `og:image:alt`.
* **Token Support:** The meta description field supports Drupal tokens, allowing for dynamic content.
* **Lightweight:** Focuses on core functionality without adding unnecessary overhead.

---

## Requirements

* Drupal 11.2
* Media (core module) - Required if using the Open Graph image functionality.

---

## Installation

1.  **Download:** Download the module from the Drupal.org project page or use Composer:
    ```bash
    composer require drupal/simple_wt_metatags
    ```
2.  **Enable:** Enable the module through the Drupal administrative interface:
    `Extend` (`/admin/modules`) -> Search for "Simple WT Metatags" -> Check the box and click "Install".

    Alternatively, use Drush:
    ```bash
    drush en simple_wt_metatags
    ```

---

## Configuration

1.  Navigate to **Configuration** > **Search and metadata** > **Simple WT Metatags Settings** (`/admin/config/search/simple-wt-metatags`).

2.  Configure the fields:
    * **Meta Description Field Machine Name:**
        Enter the **machine name** of the text field (e.g., `field_summary`) you wish to use for the global meta description tag. This field should be present on your node content types and taxonomy vocabularies.
    * **Open Graph Image Field Machine Name:**
        Enter the **machine name** of an **image media reference field** (e.g., `field_featured_image`). This field must reference a media entity of bundle type 'Image'.

3.  Click the "Save configuration" button.

---

## Usage

Once configured, the module will automatically add the `<meta name="description">` and `<meta property="og:image">` tags (along with associated OG image tags) to the `<head>` section of your site on the following pages:

* **Node Pages:** When viewing an individual node, the metatags will be generated using the values from that node's specified fields.
* **Taxonomy Term Pages:** When viewing a taxonomy term page, the metatags will be generated using the values from that term's specified fields.

---

## Troubleshooting

### Meta tags not appearing

* **Cache:** Always clear Drupal's cache after configuration changes.
    `drush cr` or visit `/admin/config/development/performance`.
* **Field Machine Names:** Double-check that the field machine names entered in the module's settings are correct and exist on your node content types and taxonomy vocabularies.
* **Field Content:** Ensure that the configured fields on your nodes or taxonomy terms actually contain data. Empty fields will not generate a metatag.
* **Media Field Configuration (for OG Image):**
    * Ensure the configured field is a **media reference field**.
    * Ensure the referenced media entity is an 'Image' type.
    * Ensure the media entity itself contains a file in its image field (e.g., `field_media_image`).

### Incorrect Meta Tag Content

* Verify the content of the configured fields on the specific node or term.
* If using tokens in the description, ensure they are correctly formed and available in the current context.

### Image Alt Text

The module attempts to find an 'alt' text for the `og:image:alt` tag in the following order:
1.  The `alt` property on the image field itself (if the field is a direct image field, not media).
2.  The alt text field on the referenced Media entity.
3.  The `name` of the Media entity as a final fallback.

Ensure one of these is populated for optimal accessibility and SEO.

---

## Maintainers

* Alexandros Pertsinidis (alexpertsi) - [https://www.drupal.org/u/alexpertsi](https://www.drupal.org/u/alexpertsi)

---

## Contributing

Contributions are welcome! Please create issues in the [project issue queue](https://www.drupal.org/project/simple_wt_metatags/issues) for bug reports, feature requests, or support questions.

---

## License

This project is licensed under the GNU General Public License, version 2 or later.
See [LICENSE.txt](LICENSE.txt) for the full license text.
