<?php
/**
 * @file
 * Generates the iframe code for the remote registration on Simplenews.
 *
 * Date: 11/feb/2014 11:38:14
 * File: simplenews_iregister_preg_callback_wrap.inc
 * Author: Callegari Stefano
 */

/**
 * Changes the original CSS and prepends the id by newsletter.
 *
 * SC 11/feb/2014 11:39:13 stefano
 */
class SimplenewsIregisterPregCallbackWrap {

  /**
   * The newsletter id.
   *
   * SC 11/feb/2014 14:58:33 stefano
   */
  protected $tid;

  /**
   * Constructor.
   *
   * SC 11/feb/2014 15:32:00 stefano
   *
   * @param int $tid
   *        the newsletter id
   */
  public function __construct($tid) {
    $this->tid = $tid;
  }

  /**
   * Prepends every tag with newsletter id.
   *
   * SC 11/feb/2014 15:33:01 stefano
   *
   * @param aray $matches
   *        values matched from preg
   *
   * @return string the new css
   */
  public function NewCSS($matches) {
    if (preg_match("/^\s*(?:body|html)(?:[\.#][^,]+)?\s*$/i", $matches[1])) {
      return $matches[1] . ' {';
    }
    $foo = preg_replace('/,/', ', div#simplenews_iregister_' . $this->tid . ' ', $matches[1]);

    return 'div#simplenews_iregister_' . $this->tid . ' ' . $foo . ' {';
  }
}
