<?php

namespace Drupal\simplesamlphp_sp\Service;

use Drupal\Core\Config\ConfigFactoryInterface;
use SimpleSAML\Auth\Simple;

/**
 * Default factory that bootstraps the SimpleSAMLphp library.
 */
final class SimpleSamlAuthClientFactory implements SimpleSamlAuthClientFactoryInterface {

  public function __construct(private readonly ConfigFactoryInterface $configFactory) {}

  /**
   * {@inheritdoc}
   */
  public function create(string $spName): SimpleSamlAuthClientInterface {
    $this->ensureLibraryLoaded();
    return new SimpleSamlAuthClient(new Simple($spName));
  }

  /**
   * Ensures the SimpleSAMLphp autoloader is available.
   */
  private function ensureLibraryLoaded(): void {
    $base = getenv('SIMPLESAMLPHP_INSTALL_DIR');
    if (!$base) {
      $base = $this->configFactory->get('simplesamlphp_sp.settings')->get('simplesamlphp_base_dir');

      if (empty($base)) {
        if (class_exists(Simple::class)) {
          // Composer already provided the library.
          return;
        }
        throw new \RuntimeException('SimpleSAMLphp base dir is empty.');
      }
    }

    if (!is_dir($base)) {
      throw new \RuntimeException("SimpleSAMLphp base dir not found: $base");
    }

    if (!defined('SIMPLESAMLPHP_DIR')) {
      define('SIMPLESAMLPHP_DIR', $base);
    }

    $autoload = $base . '/lib/_autoload.php';
    if (!file_exists($autoload)) {
      throw new \RuntimeException("SimpleSAMLphp autoloader not found at $autoload");
    }

    require_once $autoload;
  }

}
