<?php

namespace Drupal\simplesamlphp_sp\Service;

/**
 * Defines the contract for interacting with a SimpleSAML authentication client.
 */
interface SimpleSamlAuthClientInterface {

  /**
   * Ensures the request is authenticated and returns IdP attributes.
   *
   * @return array
   *   Attribute set returned by the IdP.
   */
  public function requireAuth(): array;

  /**
   * Returns the attributes currently available on the client.
   *
   * @return array
   *   Attribute set returned by the IdP.
   */
  public function getAttributes(): array;

  /**
   * Triggers logout on the underlying SimpleSAML client.
   *
   * @param string|null $returnTo
   *   Optional absolute URL for the IdP to redirect back to.
   */
  public function logout($returnTo = NULL): void;

}
