<?php

namespace Drupal\simplesamlphp_sp_test\Service;

use Drupal\simplesamlphp_sp\Service\SimpleSamlAuthClientFactoryInterface;
use Drupal\simplesamlphp_sp\Service\SimpleSamlAuthClientInterface;

/**
 * Provides the SimpleSAML mock client for functional tests.
 */
final class MockSimpleSamlAuthClientFactory implements SimpleSamlAuthClientFactoryInterface {

  /**
   * {@inheritdoc}
   */
  public function create(string $spName): SimpleSamlAuthClientInterface {
    // Ensure test doubles for ancillary SimpleSAML classes are available.
    $this->ensureSupportClassesLoaded();
    return new MockSimpleSamlAuthClient();
  }

  /**
   * Loads auxiliary SimpleSAML stubs used by the module during tests.
   */
  private function ensureSupportClassesLoaded(): void {
    static $loaded = FALSE;
    if ($loaded) {
      return;
    }

    $base = __DIR__ . '/../../lib/SimpleSAML';
    require_once $base . '/Session.php';
    require_once $base . '/Error/CriticalConfigurationError.php';
    $loaded = TRUE;
  }

}
