(function (Drupal, once) {
  Drupal.behaviors.simplesamlphpLockToggle = {
    attach(context) {
      once(
        'simplesamlphpSpLockToggle',
        'form#simplesamlphp-sp-settings',
        context,
      ).forEach((form) => {
        const lockCheckbox = form.querySelector(
          '[name="lock_external_user_fields"]',
        );
        const nativeCheckbox = form.querySelector(
          '[name="allow_native_login_for_external_users"]',
        );
        if (!lockCheckbox || !nativeCheckbox) {
          return;
        }

        const syncState = () => {
          if (lockCheckbox.checked) {
            nativeCheckbox.checked = false;
          }
        };

        lockCheckbox.addEventListener('change', syncState);
        syncState();
      });
    },
  };
})(Drupal, once);
