<?php

namespace Drupal\simplesamlphp_sp\Routing;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * Defines dynamic routes for the SimpleSAMLphp SP module.
 */
class SimpleSamlSpRouteBuilder implements ContainerInjectionInterface {

  /**
   * The configuration factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new SimpleSamlSpRouteBuilder.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The configuration factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory')
    );
  }

  /**
   * Returns a collection of routes.
   */
  public function routes() {
    $collection = new RouteCollection();
    $config = $this->configFactory->get('simplesamlphp_sp.settings');
    $login_path = $config->get('saml_login_path') ?: '/saml/login';

    $route = new Route($login_path, [
      '_controller' => '\Drupal\simplesamlphp_sp\Controller\SamlController::handleLogin',
      '_title' => 'SAML Login',
    ],
    ['_access' => 'TRUE'],
    ['no_cache' => TRUE, '_maintenance_access' => TRUE]);
    $collection->add('simplesamlphp_sp.saml_login', $route);

    return $collection;
  }

}
