<?php

namespace Drupal\simplesamlphp_sp\Service;

use SimpleSAML\Auth\Simple;

/**
 * Wrapper around \SimpleSAML\Auth\Simple exposing the client interface.
 */
final class SimpleSamlAuthClient implements SimpleSamlAuthClientInterface {

  /**
   * Constructs the wrapper.
   */
  public function __construct(private readonly Simple $inner) {}

  /**
   * {@inheritdoc}
   */
  public function requireAuth(): array {
    $this->inner->requireAuth();
    return $this->inner->getAttributes();
  }

  /**
   * {@inheritdoc}
   */
  public function getAttributes(): array {
    return $this->inner->getAttributes();
  }

  /**
   * {@inheritdoc}
   */
  public function logout($returnTo = NULL): void {
    $this->inner->logout($returnTo);
  }

}
