<?php

namespace Drupal\simplesamlphp_sp\Service;

/**
 * Creates instances that communicate with the SimpleSAMLphp library.
 */
interface SimpleSamlAuthClientFactoryInterface {

  /**
   * Builds a client for the provided service provider name.
   *
   * @param string $spName
   *   The configured service provider name.
   *
   * @return \Drupal\simplesamlphp_sp\Service\SimpleSamlAuthClientInterface
   *   The initialized client.
   *
   * @throws \SimpleSAML\Error\CriticalConfigurationError
   *   Thrown when the underlying SimpleSAML configuration is invalid.
   */
  public function create(string $spName): SimpleSamlAuthClientInterface;

}
