<?php

/**
 * @file
 * Documents hooks provided by the SimpleSAMLphp SP module.
 */

use Drupal\user\UserInterface;

/**
 * Reacts to a successful SimpleSAMLphp login before redirect.
 *
 * Implementations may update the authenticated user's data based on the IdP
 * attributes (for example, syncing roles or profile fields). Save the user if
 * changes should persist.
 *
 * @param \Drupal\user\UserInterface $account
 *   The authenticated Drupal user.
 * @param array $attributes
 *   Raw attribute data returned by the IdP. Attribute values are provided as
 *   arrays to match the SimpleSAMLphp response format.
 * @param string $authname
 *   Unique identifier for the user provided by the IdP.
 * @param string $username
 *   Username derived from the IdP response.
 * @param string $email
 *   Email asserted by the IdP.
 */
function hook_simplesamlphp_sp_post_login(UserInterface $account, array $attributes, string $authname, string $username, string $email): void {
  if (!empty($attributes['department'][0])) {
    $account->set('field_department', $attributes['department'][0]);
  }

  if (!empty($attributes['roles']) && is_array($attributes['roles'])) {
    foreach ($attributes['roles'] as $role) {
      $account->addRole($role);
    }
  }

  $account->save();
}
