<?php

namespace Drupal\simplesamlphp_sp\Exception;

use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;

/**
 * Raised when a SAML login must be denied for policy reasons.
 */
class SamlLoginDeniedException extends AccessDeniedHttpException {

  /**
   * Machine-readable reason used to deny the login.
   *
   * @var string
   */
  protected string $reason;

  /**
   * Additional context explaining the denial.
   *
   * @var array
   */
  protected array $context;

  public function __construct(string $reason, string $message = 'SAML login denied.', array $context = [], ?\Throwable $previous = NULL, int $code = 0) {
    $this->reason = $reason;
    $this->context = $context;
    parent::__construct($message, $previous, $code);
  }

  /**
   * Gets the reason that the SAML login was denied.
   *
   * @return string
   *   Machine-readable denial reason.
   */
  public function getReason(): string {
    return $this->reason;
  }

  /**
   * Gets contextual data describing the denial.
   *
   * @return array
   *   Keyed array of context values.
   */
  public function getContext(): array {
    return $this->context;
  }

}
