<?php

namespace Drupal\simplesamlphp_sp_test\Service;

use Drupal\simplesamlphp_sp\Service\SimpleSamlAuthClientInterface;

/**
 * Lightweight SimpleSAML client used by functional tests.
 */
final class MockSimpleSamlAuthClient implements SimpleSamlAuthClientInterface {

  /**
   * Predetermined attribute list exposed by the mock IdP.
   *
   * @var array
   */
  private array $attributes;

  public function __construct() {
    $this->attributes = [
      'uid' => ['testuser_authname'],
      'name' => ['testuser'],
      'mail' => ['testuser@example.com'],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function requireAuth(): array {
    return $this->attributes;
  }

  /**
   * {@inheritdoc}
   */
  public function getAttributes(): array {
    return $this->attributes;
  }

  /**
   * {@inheritdoc}
   */
  public function logout($returnTo = NULL): void {
    $target = '/';
    if (is_string($returnTo) && $returnTo !== '') {
      $target = $returnTo;
    }
    elseif (is_array($returnTo) && !empty($returnTo['ReturnTo'])) {
      $target = $returnTo['ReturnTo'];
    }

    header('Location: ' . $target);
    header('Content-Type: text/html');
  }

}
