<?php

namespace Drupal\Tests\simplesamlphp_sp\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\simplesamlphp_sp\Controller\SamlController;
use Drupal\user\Entity\User;

/**
 * Verifies the post-login hook is invoked for enabled modules.
 */
class PostLoginHookTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'externalauth',
    'simplesamlphp_sp',
    'simplesamlphp_sp_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installEntitySchema('user');
    $this->installSchema('externalauth', ['authmap']);
    $this->installConfig(['user']);
  }

  /**
   * Ensures hook implementations run via the controller helper method.
   */
  public function testPostLoginHookExecution(): void {
    $state = $this->container->get('state');
    $state->delete('simplesamlphp_sp_test.post_login');

    $account = User::create([
      'name' => 'hook-user',
      'mail' => 'hook-user@example.com',
    ]);
    $account->save();

    $attributes = [
      'example_attribute' => ['value_1', 'value_2'],
    ];

    $controller = SamlController::create($this->container);
    $method = new \ReflectionMethod(SamlController::class, 'invokePostLoginHooks');
    $method->setAccessible(TRUE);
    $method->invoke($controller, $account, $attributes, 'authname-123', 'hook-user', 'hook-user@example.com');

    $record = $state->get('simplesamlphp_sp_test.post_login');
    $this->assertNotEmpty($record);
    $this->assertSame($account->id(), $record['uid']);
    $this->assertSame($attributes, $record['attributes']);
    $this->assertSame('authname-123', $record['authname']);
    $this->assertSame('hook-user', $record['username']);
    $this->assertSame('hook-user@example.com', $record['email']);
  }

}
