<?php

namespace Drupal\site_assistant\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;
use Drupal\Core\Entity\Attribute\ConfigEntityType;
use Drupal\Core\Entity\EntityDeleteForm;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\site_assistant\AssistantListEntryTypeInterface;
use Drupal\site_assistant\AssistantListEntryTypeListBuilder;
use Drupal\site_assistant\Form\AssistantListEntryTypeEntityForm;
use Drupal\user\Entity\EntityPermissionsRouteProvider;

/**
 * Defines the Assistant List Entry Type.
 *
 * @ingroup site_assistant
 */
#[ConfigEntityType(
  id: 'assistant_list_entry_type',
  label: new TranslatableMarkup('Assistant list entry type'),
  label_collection: new TranslatableMarkup('Assistant list entry types'),
  label_singular: new TranslatableMarkup('assistant list entry type'),
  label_plural: new TranslatableMarkup('assistant list entry types'),
  label_count: [
    'singular' => '@count assistant list entry type',
    'plural' => '@count assistant list entry types',
  ],
  bundle_of: 'assistant_list_entry',
  config_prefix: 'assistant_list_entry_type',
  admin_permission: 'administer site_assistant',
  entity_keys: [
    'id' => 'id',
    'label' => 'label',
  ],
  config_export: [
    'id',
    'label',
    'description',
  ],
  handlers: [
    'list_builder' => AssistantListEntryTypeListBuilder::class,
    'form' => [
      'default' => AssistantListEntryTypeEntityForm::class,
      'add' => AssistantListEntryTypeEntityForm::class,
      'edit' => AssistantListEntryTypeEntityForm::class,
      'delete' => EntityDeleteForm::class,
    ],
    'route_provider' => [
      'html' => AdminHtmlRouteProvider::class,
      'permissions' => EntityPermissionsRouteProvider::class,
    ],
  ],
  links: [
    'canonical' => '/admin/structure/assistant_list_entry_type/{assistant_list_entry_type}',
    'add-form' => '/admin/structure/assistant_list_entry_type/add',
    'edit-form' => '/admin/structure/assistant_list_entry_type/{assistant_list_entry_type}/edit',
    'delete-form' => '/admin/structure/assistant_list_entry_type/{assistant_list_entry_type}/delete',
    'collection' => '/admin/structure/assistant_list_entry_type',
  ],
)]
class AssistantListEntryType extends ConfigEntityBundleBase implements AssistantListEntryTypeInterface {

  /**
   * The description of the assistant list entry type.
   *
   * @var string
   */
  protected $description;

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getDescription(): string {
    return $this->description;
  }

}
