<?php

namespace Drupal\site_assistant\Entity;

use Drupal\Core\Entity\EntityInterface;

/**
 * Defines an interface for entity created timestamp tracking.
 *
 * @ingroup entity_type_characteristics
 */
interface EntityCreatedInterface extends EntityInterface {

  /**
   * Gets the timestamp the entity has been created.
   *
   * @return int
   *   The timestamp the entity has been created.
   */
  public function getCreatedTime(): int;

  /**
   * Sets the node creation timestamp.
   *
   * @param int $timestamp
   *   The node creation timestamp.
   *
   * @return $this
   *   The called node entity.
   */
  public function setCreatedTime(int $timestamp);

}
