<?php

namespace Drupal\site_assistant\Traits;

use Drupal\site_assistant\AssistantInterface;
use Drupal\site_assistant\AssistantLibraryItemInterface;

/**
 * Trait to alter/provide author information in site_assistant forms.
 */
trait SiteAssistantFormAuthorTrait {

  /**
   * Adds an author element group to the form.
   *
   * @param \Drupal\site_assistant\AssistantInterface|\Drupal\site_assistant\AssistantLibraryItemInterface $entity
   *   Entity the form is build for.
   * @param array $form
   *   The form render array.
   */
  public function addFormElementAuthor(AssistantInterface|AssistantLibraryItemInterface $entity, array &$form): void {
    /** @var array{
     *   'uid'?: array,
     *   'created'?: array,
     *   ...
     * } $form */
    $form['author'] = [
      '#type' => 'details',
      '#title' => $this->t('Authoring information'),
      '#group' => 'advanced',
      '#weight' => 90,
      '#optional' => TRUE,
    ];

    if (isset($form['uid'])) {
      // Move uid field to new group.
      $form['uid']['#group'] = 'author';
    }

    if (isset($form['created'])) {
      // Move created field to new group.
      $form['created']['#group'] = 'author';
    }
  }

}
