<?php

namespace Drupal\site_assistant\Traits;

use Drupal\site_assistant\AssistantInterface;
use Drupal\site_assistant\AssistantLibraryItemInterface;

/**
 * Trait to alter/provide meta information in site_assistant forms.
 */
trait SiteAssistantFormMetaTrait {

  /**
   * Adds a meta element group to the form.
   *
   * @param \Drupal\site_assistant\AssistantInterface|\Drupal\site_assistant\AssistantLibraryItemInterface $entity
   *   Entity the form is build for.
   * @param array $form
   *   The form render array.
   */
  public function addFormElementMeta(AssistantInterface|AssistantLibraryItemInterface $entity, array &$form): void {
    $form['meta'] = [
      '#type' => 'fieldgroup',
      '#group' => 'advanced',
      '#weight' => -10,
      '#title' => $this->t('Status'),
      '#attributes' => ['class' => ['entity-meta__header']],
      '#tree' => TRUE,
    ];

    $form['meta']['published'] = [
      '#type' => 'item',
      '#markup' => $entity->isPublished() ? $this->t('Published') : $this->t('Not published'),
      '#access' => !$entity->isNew(),
      '#wrapper_attributes' => ['class' => ['entity-meta__title']],
    ];

    /** @var int|null $last_changed */
    $last_changed = $entity->getChangedTime();
    $last_changed_rendered = ($entity->isNew() || is_null($last_changed)) ? $this->t('Not saved yet') : $this->dateFormatter->format($last_changed, 'short');
    $form['meta']['changed'] = [
      '#type' => 'item',
      '#title' => $this->t('Last saved'),
      '#markup' => $last_changed_rendered,
      '#wrapper_attributes' => ['class' => ['entity-meta__last-saved']],
    ];

    /** @var \Drupal\user\UserInterface $owner */
    $owner = $entity->getOwner();
    $form['meta']['author'] = [
      '#type' => 'item',
      '#title' => $this->t('Author'),
      '#markup' => $owner->getAccountName(),
      '#wrapper_attributes' => ['class' => ['entity-meta__author']],
    ];
  }

}
