<?php

namespace Drupal\site_assistant\Traits;

/**
 * Trait for translation related functions.
 */
trait SiteAssistantTranslationTrait {

  /**
   * Enforce a translation owner ID.
   *
   * If no owner ID is set for a translation use anonymous as owner.
   */
  protected function enforceTranslationOwnerId(): void {
    foreach (array_keys($this->getTranslationLanguages()) as $langcode) {
      $translation = $this->getTranslation($langcode);

      // If no owner has been set explicitly, make the anonymous user the owner.
      if (is_null($translation->getOwner())) {
        $translation->setOwnerId(0);
      }
    }
  }

}
